#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "asm_exit.h"
#include <errno.h>
#include <unistd.h> 
#include <fcntl.h>
#define L_S 240
#define B_F 1500
const char *wordDebug[] = 
{
    "eBPF",
    "loaded",
    "CVE",
    "UAF",
    "Message",
    "cork_config_map",
    "successfully",
    NULL
};
const char *bpftoolResult[] = 
{
    "sockmap",
    "sk_msg",
    "cork_config_map",
    "attached",
    "type sockmap", 
    NULL          
};
int tracingDebugValue = 0;
int bpftoolFlag = 0;
int debugTracing()
{
        char line[L_S];
        const char *filePath = "/sys/kernel/debug/tracing/trace_pipe";
        int found = 0;
        FILE *trace = NULL;
        int fd = -1;
        fd = open(filePath, O_RDONLY | O_NONBLOCK);
        if (fd == -1)
        {
            fprintf(stderr, 
                "\e[0;31m[-] Error opening trace_pipe: %s\e[0m\n", 
                strerror(errno));
            asmE(); 
        }    
        trace = fdopen(fd, "r");
        if (trace == NULL)
        {
            fprintf(stderr, 
                "\e[0;31m[-] Error fdopen: %s\e[0m\n", 
                strerror(errno));
            close(fd); 
            asmE();
        }
        printf("\e[0;33m[+] Check result tracing...\e[0m\n");
        while (fgets(line, L_S, trace) != NULL)
        {
            for (int r = 0; wordDebug[r] != NULL; r++)
            {
                if (strstr(line,wordDebug[r]) != NULL)
                {
                    printf("\e[0;36m[+] Word Detect in result : %s\e[0m\n",
                        wordDebug[r]); 
                    __asm__ volatile
                    (
                        "movl $0x1, %[var7]\n\t"
                        :[var7] "=m" (tracingDebugValue)
                        :
                        :
                    );
                    break;   
                }
            }
        }
        if (fclose(trace) != 0)
        {
            printf("\e[0;31m[-] Error Close file (%s)\e[0m\n", 
                filePath);
            fprintf(stderr, "[-] Error : %s\e[0m\n", 
                strerror(errno));
            asmE();
        }
        printf("\e[0;33m[+] Check result (bpftool command)...\e[0m\n");
        char buffer[B_F];
        FILE *bpftoolF = popen("bpftool map show", 
            "r");
        if (bpftoolF==NULL)
        {
            printf("\e[0;31m[-] Error Run command (bpftool) !\e[0m\n");
            fprintf(stderr,
                "\e[0;31m[-] Error : %s\e[0m\n", 
                strerror(errno));
            asmE();
        }
        printf("\e[0;33m[+] Checking BPF maps...\e[0m\n");
        while (fgets(buffer, 
            B_F, 
            bpftoolF) != NULL)
        {
            for  (int u = 0; bpftoolResult[u] != NULL; u++)
            {
                if (strstr(buffer, bpftoolResult[u]) != NULL)
                {
                    printf("\e[0;36m[+] Word Found (bpftool) : %s\e[0m\n", 
                        bpftoolResult[u]);
                    __asm__ volatile
                    (
                        "movl $0x1, %[var7]\n\t"
                        :[var7] "=m" (bpftoolFlag)
                        :
                        :
                    );
                    break;
                }   
            }
            
        }
        printf("\e[0;35m[+] Result : -----------------------------\e[0m\n");
        if (tracingDebugValue != 0 || bpftoolFlag != 0)
        {
            printf("\e[0;36m[+] eBPF Program/Maps Successfully detected in kernel.\e[0m\n");
        }
        else 
        {
            printf("\e[0;31m[-] Not found Word in debug tracing path !\e[0m\n");
            printf("\e[0;31m[-] Please Check Version kernel And Support BPF.\e[0m\n");
            printf("\e[0;31m[-] Failed LOAD eBPF in kernel !\e[0m\n");
        }
        return 0;
}