#include <stdio.h>
#include <string.h>
#include <sys/socket.h>
#include <time.h>
#include <netinet/in.h> 
#include <unistd.h> 
#include <errno.h>
#include <netinet/ip_icmp.h> 
#include <arpa/inet.h> 
#include "pingC.h"
#include "asm_exit.h"
#define SEND_SIZE 64
#define RECV_SIZE 1024
unsigned short checksum(void *b, 
    int len) 
{
    unsigned short *buf = b;
    unsigned int sum = 0;
    unsigned short result;
    for (sum = 0; len > 1; len -= 2)
        sum += *buf++;
    if (len == 1)
        sum += *(unsigned char*)buf;
    sum = (sum >> 16) + (sum & 0xFFFF);
    sum += (sum >> 16);
    result = ~sum;
    return result;
}
void pingConnection(const char *ip)
{
    printf("\e[0;35m[+] Ping Connection : ------------------------\e[0m\n");
    printf("\e[0;34m[+] Start ping connection (%s) \n", 
        ip);
    struct timespec rqtp, rmtp;
    rqtp.tv_sec = 1;
    rqtp.tv_nsec = 500000000;
    register long r10R asm("r10");
    r10R = 0;
    printf("\e[0;33m[+] Sleep (%ld seconds) && (%ld nanoseconds)...\e[0m\n",
        rqtp.tv_sec, rqtp.tv_nsec);
    int ret;
    __asm__ volatile
        (
            "syscall"
            : "=a"(ret)
            : "a"(0xE6),
              "D"((long)0),
              "S"((long)0),
              "d"(&rqtp),
              "r"(r10R)
            : "rcx",
              "r11",
              "memory"
            );
    char sendSize[SEND_SIZE];
    char recvSize[RECV_SIZE];
    int socketT;
    struct sockaddr_in addr;
    socketT = socket(AF_INET,
        SOCK_RAW, 
        IPPROTO_ICMP);
    if (socketT < 0)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error create socket raw !\e[0m\n");
        printf("\e[0;31m[-] Error : %s\n", 
            strerror(errno));
        asmE();
    }
    printf("\e[0;34m[+] Create socket raw successfully (FD = %d)\e[0m\n", 
        socketT);
    memset(&addr, 
        0, 
        sizeof(addr));
    addr.sin_family = AF_INET;
    addr.sin_addr.s_addr = inet_addr(ip);
    struct icmphdr* icmpHdr = (struct icmphdr*)sendSize;
    memset(sendSize, 
        0, 
        sizeof(sendSize));
    icmpHdr->type = ICMP_ECHO;
    icmpHdr->code = 0;
    icmpHdr->un.echo.id = getpid();
    icmpHdr->un.echo.sequence = 1;
    icmpHdr->checksum = 0;
    icmpHdr->checksum = checksum((unsigned short*)icmpHdr, 
        sizeof(struct icmphdr));
    if (sendto(socketT,
        sendSize, 
        SEND_SIZE, 
        0, 
        (struct sockaddr *)&addr, 
        sizeof(addr)) <= 0)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error sendto ping connection !\e[0m\n");
        printf("\e[0;31m[-] Error : %s\n", 
            strerror(errno));
        asmE();
    }
    printf("\e[0;34m[+] Sendto ping connection successfully (%s)\e[0m\n", 
        ip);
    socklen_t addrlen = sizeof(addr);
    if (recvfrom(socketT,
        recvSize,
        RECV_SIZE, 
        0,
        (struct sockaddr*)&addr, 
        &addrlen) > 0)  
    {
        printf("\e[0;34m[+] Recvfrom ping connection successfully (%s)\e[0m\n", 
            ip);
    }  
    else 
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error recvfrom ping connection !\e[0m\n");
        printf("\e[0;31m[-] Error : %s\e[0m\n", 
            strerror(errno));
        asmE();
    }
    close(socketT);
    printf("\e[0;34m[+] Close socket raw (FD = %d)\e[0m\n",
        socketT);
    printf("\e[0;34m[+] Ping connection successfully (%s)\e[0m\n", 
        ip);
}
