
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <unistd.h>
#include "asm_exit.h"

void  asmE()
{
    printf("\e[0;35m--------------------------- [EXIT] ---------------------------\n");
    long retPid; 
    __asm__ volatile
    (
        "syscall\n\t"
        :"=a"(retPid) 
        : "a"(0x27)
        :"rcx", "r11", "memory"
    );
    pid_t mainPID = (pid_t)retPid;
    if (mainPID == 0)
    {
        fprintf(stderr,
            "\e[0;31m[-] Error get pid (PID = 0)!\n");
    }
    else 
    {
        long killRet;
        printf("\e[0;34m[+] PID : %d\n", 
            mainPID);
        printf("\e[0;34m[+] Kill PID : %d\n",
            mainPID);
        __asm__ volatile 
        (
            "syscall"
            : "=a"(killRet)             
            : "a"(0x3e),                 
            "D"((long)mainPID),       
            "S"(0x9)          
            : "rcx", "r11", "memory"
        );
        if (killRet == -1)
        {
            fprintf(stderr,
                "\e[0;31m[-] kill syscall failed (ret = %ld)\n", 
                killRet);
        }
    }  
}