#include <stdio.h>
#include <string.h>
#include <errno.h>
#include <stdlib.h> 
#include "com_c.h"
#define LINE_SIZE 256
#define COMMAND_SIZE 1000
const char *checkF[] = 
{
    "#include", 
    "core", 
    "bpf_msg", 
    NULL  
};
const char *word[] = 
{
    "bpf_msg_cork_bytes()",
    "bpf_msg_push_data()",
    "bpf_msg_pull_data()",
    "bpf_msg_pop_data()",
    "#include <linux/bpf.h>",
    "#include <bpf/bpf_helpers.h>",
    "#include <bpf/bpf_core_read.h>",
    "core_bytes",
    NULL
};
void compileP(const char *fileN)
{
    printf("\e[0;35m[+] Check C file : --------------------\e[0m\n");
    FILE *file = fopen(fileN, 
        "r");
    if (file  == NULL)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error open %s file, Exit...\e[0m\n", 
            fileN);
        goto end;
    }
    printf("\e[0;34m[+] Open %s file successfully\e[0m\n", 
        fileN);
    printf("\e[0;34m[+] Check Content %s file...\e[0m\n", 
        fileN);
    char line[LINE_SIZE];
    int wordFound = 0;
    while (fgets(line, 
        LINE_SIZE, 
        file) != NULL)
    {
        for (int i = 0; word[i] != NULL; i++)
        {
            if (strstr(line, 
                word[i]) != NULL)
            {
                printf("\e[0;36m[+] Found Header Or Function : %s\e[0m\n", 
                    word[i]);
                for (int l = 0; checkF[l] != NULL; l++)
                {
                   int resultV = strncmp(word[i],
                                        checkF[l], 
                                        strlen(checkF[l]));
                    if (resultV == 0)
                    {
                        if (strcmp(checkF[l],
                             "#include") == 0)
                        {
                            printf("\e[0;36m[+] There is a match between the words (%s).\e[0m\n", checkF[l]);
                            wordFound += 1;
                        }
                        else if (strcmp(checkF[l], 
                            "core") == 0)
                        {
                            printf("\e[0;36m[+] There is a match between the words (%s).\e[0m\n",checkF[l] );
                            wordFound += 1;
                        }
                        else if (strcmp(checkF[l], 
                            "bpf_msg") == 0)
                        {
                            printf("\e[0;36m[+] There is a match between the words (%s).\e[0m\n",checkF[l]);
                            wordFound += 1;
                        }
                        else 
                        {
                            printf("\e[0;36m[-] There is no match between the words.\e[0m\n");
                            wordFound += 1;
                        }
                        break;
                    }
                    //else if (resultV < 0)
                    //{
                        //printf("[+] The first %ld characters of str1 come before str2\n",
                          //  (size_t)strlen(checkF[l]));
                    //}
                    //else 
                    //{
                      //  printf("[+] The first %ld characters of str1 come after str2\n",
                        //    (size_t)strlen(checkF[l]));
                    //}
                }
            }          
        }
    }
    if (wordFound == 0)
    {
        fprintf(stderr,
            "\e[0;31m[-] %s file does not contain the required functions or headers\e[0m\n", 
            fileN); 
        printf("\e[0;36m[+] Please check the following functions or headers\e[0m\n");
        goto end;   
    }
    else 
    {
        printf("\e[0;34m[+] Words have been found in the %s, the %s is ready for translation.\e[0m\n", 
            fileN,
            fileN);
    }

    if (fclose(file) != 0)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error close %s file : %s\e[0m\n", 
            fileN, 
            strerror(errno));
        goto end;
    }
    printf("\e[0;34m[+] Close %s file successfully\e[0m\n", 
        fileN);
    char command[COMMAND_SIZE];
    const char *KERNEL_PATH = "/usr/src/linux-headers-6.12.38+kali-amd64"; 
    int len = snprintf(command, 
        COMMAND_SIZE, 
        "clang -O2 -g -target bpf -c %s -o bpf_injection.o \
				-nostdinc \
				-I/usr/lib/clang/19/include \
				-I%s/arch/x86/include \
				-I%s/arch/x86/include/generated \
				-I%s/include \
				-I%s/include/uapi \
				-I%s/include/generated/uapi \
				-I%s/include/asm-generic \
				-I/usr/include", 
        fileN,
        KERNEL_PATH,
        KERNEL_PATH,
        KERNEL_PATH,
        KERNEL_PATH,
        KERNEL_PATH,
        KERNEL_PATH);
    if (len < 0 || len >= COMMAND_SIZE)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error creating compile command, Exit...\e[0m\n");
        fprintf(stderr,
            "\e[0;31m[-] Error : %s\n", 
            strerror(errno));
        goto end;
    }
    printf("\e[0;35m--------------------------------------------------------\e[0m\n");
    printf("\e[0;37m[+] Compile command: clang -O2 -g -target bpf -c %s -o bpf_injection.o\n"
       "\t-nostdinc\n"
       "\t-I/usr/lib/clang/19/include\n"
       "\t-I%s/arch/x86/include\n"
       "\t-I%s/arch/x86/include/generated\n"
       "\t-I%s/include\n"
       "\t-I%s/include/uapi\n"
       "\t-I%s/include/generated/uapi\n"
       "\t-I%s/include/asm-generic\n"
       "\t-I/usr/include\n",
       fileN,
       KERNEL_PATH, 
       KERNEL_PATH, 
       KERNEL_PATH,
       KERNEL_PATH, 
       KERNEL_PATH, 
       KERNEL_PATH);

    printf("\e[0;35m--------------------------------------------------------\e[0m\n");
    int val = system(command);
    if (val == -1)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error execve compile command !\e[0m\n");
        fprintf(stderr,
            "\e[0;31m[-] Error : %s\e[0m\n", 
            strerror(errno));
        goto end;
    }
    printf("\e[0;34m[+] Compile bpf_injection.c file successfully\e[0m\n");
    return ;
    end :
        const char *mes1 = "[-] Exit syscall...\e[0m\n";
        size_t len1 = strlen(mes1);
        __asm__ volatile 
        (
            "mov $0x1, %%rax\n\t"
            "mov $0x1, %%rdi\n\t"
            "mov %[mes1], %%rsi\n\t"
            "mov %[len1], %%rdx\n\t"
            "syscall\n\t"
            "Exit:\n\t"
            "mov $0x0, %%rdi\n\t"
            "mov $0x3C, %%rax\n\t"
            "syscall\n\t"
            "Run:\n\t"
            :
            :[mes1]"r"(mes1), 
             [len1]"r"(len1)
            :"rdi", 
             "rax", 
             "rcx", 
             "r11", 
             "memory"
        );
}