#include <libelf.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include "asm_exit.h"
Elf *bpfElf;
Elf32_Ehdr *ehdr32;
Elf64_Ehdr *ehdr64;
int os32bit = 0;
int os64bit = 0;
int elfversion32bit = 0;
int elfversion64bit = 0;
int bpffiletype32bit = 0;
int bpffiletype64bit = 0;
int mipsFlag64bit = 0;
int mipsFlag32bit = 0;
int section = 0;
Elf_Scn *scn = NULL;
void checkElf()
{
    printf("\e[0;35m---------------------------------------- [CHECK OBJ FILE] ----------------------------------------\e[0m\n");
    const char *fileName = "bpf_injection.o";
    if (elf_version(EV_CURRENT) == EV_NONE)
    {
        fprintf(stderr, 
            "\e[0;31m[-] ELF library initialization failed: %s\e[0m\n", 
            elf_errmsg(-1));
        asmE();
    }
    int fd = open(fileName, 
        O_RDONLY);
    if (fd < 0)
    {
        fprintf(stderr,
            "\e[0;31m[-] Error Read file (%s)\e[0m\n",
            fileName);
        asmE();
    }
    printf("\e[0;36m[+] Open File Success (%s).\e[0m\n", 
        fileName);
   
    bpfElf = elf_begin(fd, 
        ELF_C_READ, 
        NULL);
    if (bpfElf== NULL)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error (elf_begin) : %s\e[0m\n", 
            elf_errmsg(-1));
        asmE();
    }
    printf("\e[0;36m[+] elf_begin Call success.\e[0m\n");

    char *data = elf_getident(bpfElf, NULL);
    if (data == NULL)
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error getting ELF identity data: %s\e[0m\n", 
            elf_errmsg(-1));
        printf("\e[0;31m[-] Close elf...\e[0m\n");
        printf("\e[0;31m[-] Close file fd...\e[0m\n");
        elf_end(bpfElf);
        close(fd);
        asmE();
    }
    unsigned char elfClass  = data[EI_CLASS];
    if (elfClass == ELFCLASS64)
    {
        ehdr64 = elf64_getehdr(bpfElf);
        if (ehdr64 == NULL) 
        {
            fprintf(stderr, 
                "\e[0;31m[-] Error (elf64_getehdr) : %s\e[0m\n", 
                elf_errmsg(-1));
            printf("\e[0;31m[-] Close elf...\e[0m\n");
            printf("\e[0;31m[-] Close file fd...\e[0m\n");
            close(fd);
            elf_end(bpfElf);
            asmE();
        }
        else 
        {
            printf("\e[0;36m[+] Object File Class: 64-bit\e[0m\n"); 
            printf("\e[0;36m[+] Object File Type : ");      
            switch (ehdr64->e_type)
            {
                case ET_NONE:
                    printf("Not file type detect.\n");
                    break;
                case ET_REL:
                    printf("Relocatable file.\n");
                    break;
                case ET_EXEC:
                    printf("Executable file\n");
                    break;
                case ET_DYN:
                    printf("Shared object file.\n");
                    break;
                case ET_CORE:
                    printf("Core file\n");
                    break;
                case ET_NUM:
                    printf("Number of defined types\n");
                    break;
                case ET_LOOS:
                    printf("OS-specific range start\n");
                    break;
                case ET_HIOS:
                    printf("OS-specific range end\n");
                    break;
                case ET_LOPROC:
                    printf("Processor-specific range start\n");
                    break;
                case ET_HIPROC:
                    printf("Processor-specific range end.\n");
                    break;
                default :
                    fprintf(stderr,
                        "\n[-] Error get Object File Type.\e[0m\n");
                    break;
            }        
            if (ehdr64->e_type == ET_REL)
            {
                __asm__ volatile
                (
                    "movl $0x1, %[var8]\n\t"
                    :[var8] "=m" (bpffiletype64bit)
                    :
                    :
                );
            }
            else 
            {
                printf("[-] File type not BPF !\e[0m\n");
                printf("[-] Close elf...\e[0m\n");
                printf("[-] Close file fd...\e[0m\n");
                elf_end(bpfElf);
                close(fd);
                asmE();
            }
            printf("\e[0;36m[+] Architecture : %hu\e[0m\n", 
                ehdr64->e_machine);        
            printf("\e[0;36m[+] Object file version : %u\e[0m\n", 
                ehdr64->e_version);  
            if (ehdr64->e_version == EV_CURRENT)
            {
                 __asm__ volatile
                (
                    "movl $0x1, %[var9]\n\t"
                    :[var9] "=m" (elfversion64bit)
                    :
                    :
                );
            }
            else 
            {
                fprintf(stderr,
                    "\e[0;31m[-] File version not elf (64-bit)!\e[0m\n");
            }
            printf("\e[0;36m[+] Entry point virtual address : %lu\e[0m\n", 
                (unsigned long)ehdr64->e_entry); 
            printf("\e[0;36m[+] Program header table file offset : %lu\e[0m\n", 
                (unsigned long)ehdr64->e_phoff); 
            printf("\e[0;36m[+] Section header table file offset : %lu\e[0m\n", 
                (unsigned long)ehdr64->e_shoff);
            printf("\e[0;36m[+] Processor-specific flags : %u\e[0m\n",
                 ehdr64->e_flags);
            if (ehdr64->e_flags == EF_CPU32)
            {
                fprintf(stderr, "\e[0;31m[-] MIPS FLAG detect (64-bit)!\e[0m\n");
            }
            else 
            {
                printf("\e[0;36m[+] Flag MIPS not Detect (64-bit).\e[0m\n");
                 __asm__ volatile
                (
                    "movl $0x1, %[var8]\n\t"
                    :[var8] "=m" (mipsFlag64bit)
                    :
                    :
                );

            }
            printf("\e[0;36m[+] ELF header size in bytes : %hu\e[0m\n", 
                ehdr64->e_ehsize);
            printf("\e[0;36m[+] Program header table entry size : %hu\e[0m\n", 
                ehdr64->e_phentsize); 
            printf("\e[0;36m[+] Program header table entry count : %hu\e[0m\n", 
                ehdr64->e_phnum);
            printf("\e[0;36m[+] Section header table entry size : %hu\e[0m\n", 
                ehdr64->e_shentsize);
            printf("\e[0;36m[+] Section header table entry count : %hu\e[0m\n", 
                ehdr64->e_shnum); 
            printf("\e[0;36m[+] Section header string table index : %hu\e[0m\n", 
                ehdr64->e_shstrndx);
            printf("\e[0;36m[+] Check Section elf...\e[0m\n");
            while ((scn = elf_nextscn(bpfElf, scn)) != NULL)
            {
                Elf64_Shdr *shdr64;
                shdr64 = elf64_getshdr(scn);
                char *sectionName = elf_strptr(bpfElf, ehdr64->e_shstrndx, shdr64->sh_name);
                Elf_Data *dataSection;  
                
                if (sectionName == NULL) 
                {
                        sectionName = "UNKNOWN/DECODING_ERROR";
                }
                dataSection = elf_getdata(scn, NULL);
                if (dataSection == NULL)
                {
                    fprintf(stderr, 
                        "\e[0;31m[-] Error Get Data Section !\e[0m\n");
                    continue;
                }
                printf("\e[0;34m[+] Get data Sucess.\e[0m\n");
                printf("\n\e[0;35m[+] Section #%d: %s\n", section++, sectionName);
                printf("\e[0;36m[+] Type: ");
                switch (shdr64->sh_type)
                {
                    case SHT_PROGBITS: 
                        printf("SHT_PROGBITS (Code/Data)\n"); 
                        break;
                    case SHT_SYMTAB: 
                        printf("SHT_SYMTAB (Symbol Table)\n"); 
                        break;
                    case SHT_STRTAB: 
                        printf("SHT_STRTAB (String Table)\n"); 
                        break;
                    case SHT_RELA: 
                        printf("SHT_RELA (Relocation)\n"); 
                        break;
                        case SHT_NOBITS: 
                        printf("SHT_NOBITS (BSS - No Data)\n"); 
                        break;
                    case SHT_NOTE: 
                        printf("SHT_NOTE (Notes)\n"); 
                        break;
                    case SHT_DYNSYM: 
                        printf("SHT_DYNSYM (Dynamic Symbols)\n"); 
                        break;
                    case SHT_REL: 
                        printf("SHT_REL (Relocation)\n"); 
                        break;
                    case SHT_SHLIB: 
                        printf("SHT_SHLIB (Reserved)\n"); 
                        break;
                    case SHT_NULL: 
                        printf("SHT_NULL (Inactive)\n"); 
                        break;
                    default: 
                        printf("Unknown/Specific Type (%u)\n", 
                            shdr64->sh_type); 
                        break;
                }
                printf("\e[0;36m[+] Section Flag : 0x%lx (", 
                    (unsigned long)shdr64->sh_flags);
                if (shdr64->sh_flags & SHF_WRITE) 
                {
                    printf("W - Writable  |");
                }
                if (shdr64->sh_flags & SHF_ALLOC) 
                {
                    printf("A - Allocated |");
                }
                if (shdr64->sh_flags & SHF_EXECINSTR) 
                {
                    printf("X - Executable |");
                }
                if (shdr64->sh_flags & SHF_STRINGS) 
                {
                    printf("S - Strings | ");
                }
                if (shdr64->sh_flags & 0x40000000) 
                {
                    printf("BPF-Info-Link | ");
                }
                printf(")\e[0m\n");
                printf("\e[0;36m[+] Section virtual addr at execution : %lu\e[0m\n",  
                    (unsigned long)shdr64->sh_addr);
                printf("\e[0;36m[+] Section file offset : %lu\e[0m\n", 
                    (unsigned long)shdr64->sh_offset);
                printf("\e[0;36m[+] Section size in bytes : %lu\e[0m\n", 
                    (unsigned long)shdr64->sh_size);
                printf("\e[0;36m[+] Link to another section : %u\e[0m\n", 
                    shdr64->sh_link);
                printf("\e[0;36m[+] Additional section information : %u\e[0m\n", 
                    shdr64->sh_info);
                printf("\e[0;36m[+] Section alignment : %lu\e[0m\n", 
                    (unsigned long)shdr64->sh_addralign);
                printf("\e[0;36m[+] Entry size if section holds table : %lu\e[0m\n", 
                    (unsigned long)shdr64->sh_entsize);
            }
        }
        int tA=0;
        printf("\e[0;35m[+] RESULT --------------------------------------\e[0m\n");
        
        if (bpffiletype64bit == 1 && elfversion64bit == 1) 
        {
            tA = 1;
            printf("\e[0;36m[+] %s Detected as a valid BPF Relocatable file.\e[0m\n", 
                fileName);
            goto finalMessage;
        }
        else if (mipsFlag64bit == 1 && elfversion64bit == 1)
        {
            tA = 1;
            printf("\e[0;36m[+] %s Detected valid ELF version.\e[0m\n", fileName);
            goto finalMessage;
        }
        else 
        {
            printf("[-] %s Not detected as a valid BPF object file.\e[0m\n", fileName);
        }
        finalMessage:
            if (tA != 0)
            {
                printf("\e[0;34m[+] Please Run poc and check result log bpf printk\e[0m\n");
            }
            else 
            {
                printf("\e[0;31m[-] Please Check %s (NOT DETECT BPF TYPE || ELF FLAG)\e[0m\n",
                    fileName);
                printf("\e[0;31m[-] Close elf...\e[0m\n");
                printf("\e[0;31m[-] Close file fd...\e[0m\n");
                elf_end(bpfElf);
                close(fd);
                asmE();
            }
        printf("-------------------------------------------------\n");
    }
    else if (elfClass == ELFCLASS32)
    {
        ehdr32 = elf32_getehdr(bpfElf);
        if (ehdr32 == NULL)
        {
            fprintf(stderr, 
                "\e[0;31m[-] Error (elf32_getehdr) : %s\e[0m\n", 
                       elf_errmsg(-1));
            printf("\e[0;31m[-] Close elf...\e[0m\n");
            printf("\e[0;31m[-] Close file fd...\e[0m\n");
            elf_end(bpfElf);
            close(fd);
            asmE();
        }
        else 
        {
            printf("\e[0;34m[+] Object File Class: 32-bit\e[0m\n");
            printf("\e[0;36m[+] Object File Type : ");    
            switch (ehdr32->e_type)
            {
                case ET_NONE:
                    printf("Not file type detect.\e[0m\n");
                    break;
                case ET_REL:
                    printf("Relocatable file.\e[0m\n");
                    break;
                case ET_EXEC:
                    printf("Executable file\e[0m\n");
                    break;
                case ET_DYN:
                    printf("Shared object file.\e[0m\n");
                    break;
                case ET_CORE:
                    printf("Core file\n");
                    break;
                case ET_NUM:
                    printf("Number of defined types\e[0m\n");
                    break;
                case ET_LOOS:
                    printf("OS-specific range start\e[0m\n");
                    break;
                case ET_HIOS:
                    printf("OS-specific range end\e[0m\n");
                    break;
                case ET_LOPROC:
                    printf("Processor-specific range start\e[0m\n");
                    break;
                case ET_HIPROC:
                    printf("Processor-specific range end.\e[0m\n");
                    break;
                default :
                    fprintf(stderr,
                        "\n\e[0;31m[-] Error get file type obj !\e[0m\n");
                    break;
            }     
            if (ehdr32->e_type == ET_REL)
            {
                __asm__ volatile
                (
                    "movl $0x1, %[var8]\n\t"
                    :[var8] "=m" (bpffiletype32bit)
                    :
                    :
                );
            }
            else 
            {
                printf("\e[0;31m[-] File type not BPF !\e[0m\n");
            }
            printf("\e[0;36m[+] Architecture : ");   
            switch (ehdr32->e_version)
            {
                case EV_NONE:
                    printf("Invalid ELF version !\n");
                    break;
                case EV_CURRENT:
                    printf("Current version !\e[0m\n");
                    break;
                case EV_NUM:
                    break;  
                default :
                    fprintf(stderr,
                        "\n\e[0;31m[-] Error Detect Version ELF !\e[0m\n");
                    break;
            }     
            if (ehdr32->e_version==EV_CURRENT)
            {
               __asm__ volatile
               (
                    "movl $0x1, %[var9]\n\t"
                    :[var9] "=m" (elfversion32bit)
                    :
                    :
               );
            }
            else 
            {
                fprintf(stderr,"[-] File version not elf (32-bit)!\e[0m\n");
            }
            printf("\e[0;36m[+] Object file version : %u\e[0m\n", 
                ehdr32->e_version);   
            printf("\e[0;36m[+] Entry point virtual address : %u\e[0m\n", 
                ehdr32->e_entry);
            printf("\e[0;36m[+] Program header table file offset : %u\e[0m\n", 
                ehdr32->e_phoff); 
            printf("\e[0;36m[+] Section header table file offset : %u\e[0m\n", 
                ehdr32->e_shoff);
            printf("\e[0;36m[+] Processor-specific flags : %u\e[0m\n", 
                ehdr32->e_flags);
            if (ehdr32->e_flags == EF_CPU32)
            {
                fprintf(stderr, "\e[0;31m[-] MIPS FLAG detect (32-bit)!\e[0m\n");
                
            }
            else 
            {
                printf("\e[0;36m[+] Flag MIPS not Detect (32-bit).\e[0m\n");
                __asm__ volatile
                (
                    "movl $0x1, %[var8]\n\t"
                    :[var8] "=m" (mipsFlag32bit)
                    :
                    :
                );

            }
            printf("\e[0;36m[+] ELF header size in bytes : %hu\e[0m\n", 
                ehdr32->e_ehsize);   
            printf("\e[0;36m[+] Program header table entry size : %hu\e[0m\n", 
                ehdr32->e_phentsize); 
            printf("\e[0;36m[+] Program header table entry count : %hu\e[0m\n", 
                ehdr32->e_phnum);  
            printf("\e[0;36m[+] Section header table entry size : %hu\e[0m\n", 
                ehdr32->e_shentsize);
            printf("\e[0;36m[+] Section header table entry count : %hu\e[0m\n", 
                ehdr32->e_shnum);   
            printf("\e[0;36m[+] Section header string table index : %hu\e[0m\n", 
                ehdr32->e_shstrndx);
        
        }
        int tA32=0;
        printf("\e[0;35m[+] RESULT --------------------------------------\e[0m\n");
        
        if (bpffiletype32bit == 1 && elfversion32bit == 1) 
        {
            tA32 = 1;
            printf("\e[0;36m[+] %s Detected as a valid BPF Relocatable file.\e[0m\n", fileName);
            goto finalMessage1;
        }
        else if (mipsFlag32bit == 1 && elfversion32bit == 1)
        {
            tA32 = 1;
            printf("\e[0;36m[+] %s Detected valid ELF version (32-bit).\e[0m\n", fileName);
            goto finalMessage1;
        }
        else 
        {
            printf("\e[0;31m[-] %s Not detected as a valid BPF object file (32-bit).\e[0m\n", fileName);
        }
        finalMessage1:
            if (tA32 != 0)
            {
                printf("\e[0;34m[+] Please Run poc and check result log bpf printk (32-bit).\e[0m\n");
            }
            else 
            {
                printf("\e[0;31m[-] Please Check %s (NOT DETECT BPF TYPE || ELF FLAG) \e[0m\n",
                    fileName);
                printf("\e[0;31m[-] Close elf...\n");
                printf("\e[0;31m[-] Close file fd...\n");
                elf_end(bpfElf);
                close(fd);
                asmE();
            }
        printf("\e[0;35m-------------------------------------------------\e[0m\n"); 
    }
    else if (elfClass == ELFCLASSNONE) 
    {
        fprintf(stderr, 
            "\e[0;31m[-] Error Invalid class (ELFCLASSNONE) !\e[0m\n");
        printf("\e[0;31m[-] Close elf...\e[0m\n");
        printf("\e[0;31m[-] Close file fd...\e[0m\n");
        elf_end(bpfElf);
        close(fd);
        asmE();
    }
    else 
    {
        printf("\e[0;31m[-] Error: Unsupported ELF class (%u) !\e[0m\n", 
            elfClass);
        printf("\e[0;31m[-] Close elf...\e[0m\n");
        printf("\e[0;31m[-] Close file fd...\e[0m\n");
        elf_end(bpfElf);
        close(fd);
        asmE();
    }
    printf("\e[0;31m[-] Close elf...\e[0m\n");
    printf("\e[0;31m[-] Close file fd...\e[0m\n");
    elf_end(bpfElf);
    close(fd); 
}
